<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

// Check if user has permission to view products
// Check if user has any product-related permissions
$productPermissions = [
    'view_products', 'manage_products', 'search_products', 'view_inventory'
];

if (!hasAnyPermission($productPermissions)) {
    header('HTTP/1.1 403 Forbidden');
    echo json_encode(['error' => 'You don\'t have permission to search products']);
    exit;
}

if (false && !hasPermission('view_products')) { // Disable the old check
    echo json_encode(['error' => 'Permission denied']);
    exit;
}

if (isset($_GET['query'])) {
    $query = trim($_GET['query']);
    
    if (strlen($query) >= 2) {
        try {
            $stmt = $pdo->prepare("
                SELECT id, name 
                FROM products 
                WHERE name LIKE ? 
                ORDER BY name 
                LIMIT 10
            ");
            $stmt->execute(['%' . $query . '%']);
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode($results);
        } catch (PDOException $e) {
            echo json_encode(['error' => 'Database error']);
        }
    } else {
        echo json_encode([]);
    }
} else {
    echo json_encode(['error' => 'No query provided']);
} 